#ifndef _LIBOSPCH_H
#define _LIBOSPCH_H

#include <windows.h>
#include "types.h"
#include "public.h"


//  ()
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int   WINAPI  CreateDeviceInstance(const PUCHAR DeviceNumber);
extern  "C"  DLL_API  void  WINAPI  ReleaseDeviceInstance(const PUCHAR DeviceNumber);


//   - ,      
//---------------------------------------------------------------------------
extern  "C"  DLL_API  ULONG  WINAPI DeviceSupportedCount(void);
extern  "C"  DLL_API  char*  WINAPI GetFullDeviceName(PUCHAR DeviceNumber);
extern  "C"  DLL_API  ULONG  WINAPI GetDeviceSlotID(PUCHAR DeviceNumber);

// -  ( ) 
//---------------------------------------------------------------------------

extern  "C"  DLL_API  char*  WINAPI  GetErrorMessage();

//---------------------------------------------------------------------------


//     (1/2/E3)
//---------------------------------------------------------------------------
// RefType     : 0 - , 1 - 

extern  "C"  DLL_API  int  WINAPI  rSynthLoad(const PUCHAR DeviceNumber, const PUCHAR RefType);

//---------------------------------------------------------------------------



//  
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  FPGALoad(const PUCHAR DeviceNumber, const PCHAR szFPGAName, const PCHAR szFilename);

//---------------------------------------------------------------------------



//  
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  RAMLoad(const PUCHAR DeviceNumber, const PCHAR szFilename, const UCHAR ndxRAM);

//---------------------------------------------------------------------------



//  
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  ADCLoad(const PUCHAR DeviceNumber);

//---------------------------------------------------------------------------



//  1-  
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  FirstGainControl(const PUCHAR DeviceNumber, const PFIRST_GC FirstGC);

//---------------------------------------------------------------------------



//  2-  
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  SecondGainControl(const PUCHAR DeviceNumber, const PSECOND_GC SecondGC);

//---------------------------------------------------------------------------



//  
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  PLLControl(const PUCHAR DeviceNumber, const PPLL_CONTROL PLLCtrl);

//---------------------------------------------------------------------------



//   
//    
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  SetCarrier(const PUCHAR DeviceNumber, const PDOUBLE Carrier);
extern  "C"  DLL_API  int  WINAPI  MeasureCarrier(const PUCHAR DeviceNumber, PVOID Reserved, const PDOUBLE MeasuredCarrier);

//---------------------------------------------------------------------------



//   
//    
//    
//     
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  SetTiming(const PUCHAR DeviceNumber, const PDOUBLE Timing);
extern  "C"  DLL_API  int  WINAPI  SetTimingMode(const PUCHAR DeviceNumber, const PTIMING_MODE TFMode);
extern  "C"  DLL_API  int  WINAPI  GetTimingControl(const PUCHAR DeviceNumber, PTIMING_CTRL TFCtrl);
extern  "C"  DLL_API  int  WINAPI  MeasureTiming(const PUCHAR DeviceNumber, PVOID Reserved, PDOUBLE MeasuredTiming);

//---------------------------------------------------------------------------



//    
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  GetPCBTemperature(const PUCHAR DeviceNumber, PFLOAT tPCB);
extern  "C"  DLL_API  int  WINAPI  GetFPGATemperature(const PUCHAR DeviceNumber, PFLOAT tFPGA);

//---------------------------------------------------------------------------



//      
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  GetModuleSerialNumber(const PUCHAR DeviceNumber, PCHAR szSerialNumber);
extern  "C"  DLL_API  int  WINAPI  GetModuleVersion(const PUCHAR DeviceNumber, PCHAR szVersion);

//---------------------------------------------------------------------------



//    :
// .   
// . ""  
// . 
// .  
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  EQErrorTblLoad(const PUCHAR DeviceNumber, const PCHAR szErrTableFilename);
extern  "C"  DLL_API  int  WINAPI  EQManualCoeffLoad(const PUCHAR DeviceNumber, const PEQ_COEFF EQCoeff);
extern  "C"  DLL_API  int  WINAPI  EQControl(const PUCHAR DeviceNumber, const PEQ_CTRL EQCtrl);
extern  "C"  DLL_API  int  WINAPI  EQGetCoeff(const PUCHAR DeviceNumber, PEQ_COEFF EQCoeff);

//---------------------------------------------------------------------------



//  
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  FilterLoad(const PUCHAR DeviceNumber, const PCHAR szFilterDir, const PUCHAR ID, const PUCHAR CPS);

//---------------------------------------------------------------------------



//  IQ-
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  IQControl(const PUCHAR DeviceNumber, const PIQCH_CTRL IQCtrl);

//---------------------------------------------------------------------------



//  DMD-
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  DMDControl(const PUCHAR DeviceNumber, const PDMDCH_CTRL DMDCtrl);

//---------------------------------------------------------------------------


//  DMA3-
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  DMA3CHControl(const PUCHAR DeviceNumber, const PDMA3CH_CTRL Ctrl);

//---------------------------------------------------------------------------



//    :
// .   
// .   
// .   
// . 
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  SimulatorSetCarrier(const PUCHAR DeviceNumber, const PDOUBLE SimulatorCarrier);
extern  "C"  DLL_API  int  WINAPI  SimulatorSetTiming(const PUCHAR DeviceNumber, const PDOUBLE SimulatorTiming);
extern  "C"  DLL_API  int  WINAPI  SimulatorLoad(const PUCHAR DeviceNumber, const PCHAR szFilename);
extern  "C"  DLL_API  int  WINAPI  SimulatorControl(const PUCHAR DeviceNumber, const PBOOL Enabled);

//---------------------------------------------------------------------------



//    Master-:
// . 
// .   
// .   
// .    
// .     ....
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  MasterLoad(const PUCHAR DeviceNumber, PMEMORY_DATA MemoryData);
extern  "C"  DLL_API  int  WINAPI  MasterStart(const PUCHAR DeviceNumber, const PUINT Mode);
extern  "C"  DLL_API  int  WINAPI  MasterStop(const PUCHAR DeviceNumber);
extern  "C"  DLL_API  int  WINAPI  MasterGetBuffers(const PUCHAR DeviceNumber, PMEMORY_DATA MemoryData);
extern  "C"  DLL_API  int  WINAPI  MasterGetInterruptInfo(const PUCHAR DeviceNumber, PINTERRUPT_INFO InterruptInfo);
//---------------------------------------------------------------------------


//      
//---------------------------------------------------------------------------
extern  "C"  DLL_API  int  WINAPI  ReadChannelData(
        PUCHAR  DeviceNumber,    //    
        ULONG   ChannelID,       //  
        PVOID   Buffer,          //   
        ULONG   RequiredSize,    // -  
        PULONG  ActualSize,      // -  
        ULONG   Timeout          // -, 
    );
//  :
//  0             . ActualSize   - 
//              
// -1          (Block missed)
// -2            (    )
//           (Data input is not continuous)
// -3              (Event creation failed)
//---------------------------------------------------------------------------



//     
//-------------------------------------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  GetInterfaceVersion(const PUCHAR DeviceNumber, PUCHAR Version);

//-------------------------------------------------------------------------------------------------------



//   :
// .    
// .    
// .     
//

extern  "C"  DLL_API  int  WINAPI  _devinp(PUCHAR DeviceNumber, PPORT_DATA Data);
extern  "C"  DLL_API  int  WINAPI  _devoutp(PUCHAR DeviceNumber, PPORT_DATA Data);
extern  "C"  DLL_API  int  WINAPI  GetFPGABaseAddress(PUCHAR DeviceNumber, PFPGA_BAR fpga);

//---------------------------------------------------------------------------



//    ( )
//   
//   
//---------------------------------------------------------------------------
                                   
extern  "C"  DLL_API  int  WINAPI  SetSignalType(const PUCHAR DeviceNumber, const PUCHAR ID, const PUCHAR SR, const PUCHAR CT);
extern  "C"  DLL_API  int  WINAPI  LoadPackMode(const PUCHAR DeviceNumber, const PCHAR szFilename);
extern  "C"  DLL_API  int  WINAPI  GetSignalParameters(const PUCHAR DeviceNumber, PMOD_PARAMS Params);

//---------------------------------------------------------------------------



//  
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  AttenuatorControl(const PUCHAR DeviceNumber, const PULONG AttCtrl);

//---------------------------------------------------------------------------



//   -  
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  GetBitStatus(const PUCHAR DeviceNumber, PBIT_STATUS Status);

//---------------------------------------------------------------------------



//      
//     
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  GetGCValues(const PUCHAR DeviceNumber, PGC_VALUES GCValues);

//---------------------------------------------------------------------------



//     
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  Counters(const PUCHAR DeviceNumber, PCOUNTERS Counters);

//---------------------------------------------------------------------------



//    :
// . 
// . 
// . 
//---------------------------------------------------------------------------
                            
extern  "C"  DLL_API  int  WINAPI  DMPXLoad(const PUCHAR DeviceNumber, const PCHAR szFilename);
extern  "C"  DLL_API  int  WINAPI  DMPXControl(const PUCHAR DeviceNumber, const PDMPX_CTRL Ctrl);
extern  "C"  DLL_API  int  WINAPI  DMPXStatus(const PUCHAR DeviceNumber, PDMPX_STATUS Status);

//---------------------------------------------------------------------------



//   ( )
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  InstallLicense(const PUCHAR DeviceNumber, const PCHAR Key, const PULONG KeyLengthInBytes);

//---------------------------------------------------------------------------



//     :
// .    
// .   FIFO
//---------------------------------------------------------------------------

extern  "C"  DLL_API  int  WINAPI  ISOCVRTSetTiming(const PUCHAR DeviceNumber, const PFLOAT CodeN1, const PFLOAT CodeN2);
extern  "C"  DLL_API  int  WINAPI  ISOCVRTGetLoading(const PUCHAR DeviceNumber, PULONG FIFOLoad);

//---------------------------------------------------------------------------



//    L-
// .    (Reserved = NULL)
// .    
// .     (/)
// .       L-

extern  "C"  DLL_API  int  WINAPI  lSynthInit(const PUCHAR DeviceNumber, const PVOID Reserved);
extern  "C"  DLL_API  int  WINAPI  InitLConvertorVList(const PUCHAR DeviceNumber);
extern  "C"  DLL_API  int  WINAPI  GetLConvertorType(const PUCHAR DeviceNumber, PUCHAR Type);
extern  "C"  DLL_API  int  WINAPI  GetLConvertorSerialNumber(const PUCHAR DeviceNumber, PCHAR szSerialNumber);
extern  "C"  DLL_API  int  WINAPI  GetLConvertorVersion(const PUCHAR DeviceNumber, PCHAR szVersion);


//     ( -1)
//---------------------------------------------------------------------------
extern  "C"  DLL_API  int  WINAPI  CircuitReset(const PUCHAR DeviceNumber, const PRESET_CTRL Ctrl);
//---------------------------------------------------------------------------

//      
//   
//---------------------------------------------------------------------------
extern  "C"  DLL_API  int  WINAPI  SimulatorDataLoad(const PUCHAR DeviceNumber, const PUCHAR Data, const PULONG Length);
extern  "C"  DLL_API  int  WINAPI  SimulatorDataControl(const PUCHAR DeviceNumber, const PSIMULATOR_CTRL Ctrl);
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#endif

