#ifndef _TYPES_H
#define _TYPES_H

#include <windows.h>


#ifdef OSPCHDLL_EXPORTS
#define DLL_API __declspec(dllexport)
#else
#define DLL_API __declspec(dllimport)
#endif


//
// Structures are not packed
#pragma pack(1)


/*++
         (FilterLoad)
--*/
//                                  0       1       2       3       4       5       6       7        8        9
const static PCHAR FltPrefix[] = {"ibsd", "n10d", "n15d", "n20d", "n25d", "n30d", "n35d", "n40d", "nf40d", "wded"};


typedef     double *    PDOUBLE;

/*++
                 [DEM - 0x00]
      L-
--*/
typedef struct  _FIRST_GC {
    union {
        struct {
            DWORD   Gain        :12;    // D0...D11 :    
            DWORD   Reserved0   :2;     // D12..D13 : , D12, D13   = 0
            DWORD   PulseMode   :1;     // D14      :    
            DWORD   Manual      :1;     // D15      : 0 - , 1 - 
            DWORD   Att         :5;     // D16..D20 :     
            DWORD   Reserved1   :3;     // D21..D23 : 
            DWORD   Threshold   :8;     // D24..D31 :    
        } bits;
    DWORD   AsULONG;
    };

    _FIRST_GC() {AsULONG = 0;}

} FIRST_GC, *PFIRST_GC;


/*++
                 [DEM - 0x00]
      L-
--*/
typedef struct  _FIRST_GC_EX {
    union {
        struct {
            DWORD   Level       :12;    // D0...D11 :     ""  
            DWORD   LHSwitch    :1;     // D12      : 0 -   , 1 - 
            DWORD   Converter   :1;     // D13      : 0 -  , 1 - 
            DWORD   PulseMode   :1;     // D14      :    
            DWORD   Manual      :1;     // D15      : 0 - , 1 - 
            DWORD   Att         :7;     // D16..D22 :     
            DWORD   Reserved1   :1;     // D23      : 
            DWORD   Reserved2   :8;     // D24..D31 :    0
        } bits;
    DWORD   AsULONG;
    };

    _FIRST_GC_EX() {AsULONG = 0;};

} FIRST_GC_EX, *PFIRST_GC_EX;


/*++
                 [DEM - 0x12, 0x14]
--*/
typedef struct  _SECOND_GC {
    union {
        struct {
            DWORD   Gain        :16;    // D0...D15 :    
            DWORD   Manual      :1;     // D16      : 0 - , 1 - 
            DWORD   Reserved0   :7;     // D17..D23 : 
            DWORD   TimeHi      :3;     // D24..D26 :       (T_hi)
            DWORD   Reserved1   :1;     // D27      : 
            DWORD   TimeLo      :3;     // D28..D30 :       (T_lo)
            DWORD   Reserved2   :1;     // D31      : 
        } bits;
    DWORD   AsULONG;
    } ctrl;

    union {
        struct  {
            DWORD   Threshold   :8;     // D0...D7  :    
            DWORD   Reserved0   :8;     // D8..D15  : 
            DWORD   Limit       :12;    // D16..D27 :  .  
            DWORD   Reserved1   :4;     // D28..D31 : 
        } bits;
    DWORD   AsULONG;
    } thresh;

    _SECOND_GC() {ctrl.AsULONG = thresh.AsULONG = 0;};

} SECOND_GC, *PSECOND_GC;


/*++
           [DEM - 0x16]
--*/
typedef struct  _PLL_CONTROL {
    union {
        struct {

            DWORD   Band            :2;     // D0...D1  :  ; 0  1/50, 1  1/100, 2  1/200, 3  1/400    
            DWORD   PIMode          :1;     // D2       :  PI-
            DWORD   CDRotation      :1;     // D3       :    45'  4,  22.5'  8
            DWORD   Reserved0       :9;     // D4..D12  : 
            DWORD   TFTraceDisable  :1;     // D13      :     
            DWORD   PLLEnable       :1;     // D14      :   
            DWORD   CFTraceDisable  :1;     // D15      :     
            DWORD   CFThreshold     :8;     // D16..D23 :      
            DWORD   Reserved1       :8;     // D24..D31 : 

        } bits;

    DWORD   AsULONG;

    };

    _PLL_CONTROL() {AsULONG = 0;};

} PLL_CONTROL, *PPLL_CONTROL;


/*++
        
--*/
typedef	struct _TIMING_CTRL {

    DWORD   Kvps;

    union {
        struct {
            DWORD   Kdec        :12;    // D0...D11
            DWORD   Reserved    :4;     // D12..D15
            DWORD   Kshft       :4;     // D16..D19
        } bits;
    DWORD AsULONG;
    } coeff;

    DWORD   Diap;
    DWORD   Kpt;

    _TIMING_CTRL() {coeff.AsULONG = 0;};

} TIMING_CTRL, *PTIMING_CTRL;


#define     CORRECTOR_LENGH     13

/*++
            [DEM - 0x0D]
--*/
typedef struct  _EQ_CONTROL {
    union {
        struct {
            DWORD   Spd             :2;     // D0, D1   :   
            DWORD   Reserved0       :6;     // D2..D7   : 
            DWORD   Enabled         :1;     // D8       :   .(1) / .(0)
            DWORD   Reserved1       :1;     // D9       : 
            DWORD   Process         :1;     // D10      : . (1) / . (0)    
            DWORD   Reserved2       :21;    // D11..D31 : 
        } bits;
    DWORD   AsULONG;
    };

    _EQ_CONTROL() {AsULONG = 0;};

} EQ_CTRL, *PEQ_CTRL;


/*++
      
--*/
typedef struct _EQ_COEFF {

    DWORD       Count;                      // - -
    PWORD       pRe;                        //    .  
    PWORD       pIm;                        //    .  

} EQ_COEFF, *PEQ_COEFF;


/*++
          [DEM - 0x1E]
     I  Q     
--*/
typedef struct _IQCH_CONTROL {
    union {
        struct {
            DWORD       Mode        :1;     // D0       : 1 -  , 0 -  
            DWORD       Reserved0   :3;     // D1..D3   : 
            DWORD       Master      :1;     // D4       : 1 -     Master
            DWORD       SingleMode  :1;     // D5       : 1 -   
            DWORD       Reserved1   :2;     // D6..D7   : 
            DWORD       Reset       :1;     // D8       : 1 -  
            DWORD       Reserved2   :3;     // D9..D11  : 
            DWORD       FIFOBlock   :3;     // D12..D14 :    
            DWORD       Reserved3   :14;    // D15..D28 : 
            DWORD       Format      :2;     // D29..D30 : 0 - 8 ; 1 - 16 , 2 -   ; 3 - ""
            DWORD       Slave       :1;     // D31      : 1 -     Slave
        } bits;

    DWORD   AsULONG;

    };

    _IQCH_CONTROL() {AsULONG = 0;};

} IQCH_CTRL, *PIQCH_CTRL;


/*++
          [DEM - 0x1F]
     I  Q    
--*/
typedef struct _DMA3CH_CONTROL {
    union {
        struct {
            DWORD       Reserved0   :4;     // D0..D3   : 
            DWORD       Master      :1;     // D4       : 1 -     Master
            DWORD       SingleMode  :1;     // D5       : 1 -   
            DWORD       Reserved1   :2;     // D6..D7   : 
            DWORD       Reset       :1;     // D8       : 1 -  
            DWORD       Reserved2   :3;     // D9..D11  : 
            DWORD       FIFOBlock   :3;     // D12..D14 :    
            DWORD       Reserved3   :17;    // D15..D31 : 
        } bits;

    DWORD   AsULONG;

    };

    _DMA3CH_CONTROL() {AsULONG = 0;};

} DMA3CH_CTRL, *PDMA3CH_CTRL;


/*++
           [DEM - 0x20]
--*/
typedef struct _DMDCH_CONTROL {
    union {
        struct {
            DWORD       Mode        :4;     // D0..D3   :  
            DWORD       Master      :1;     // D4       : 1 -     Master
            DWORD       Reserved1   :1;     // D5       : 
            DWORD       Bitorder    :1;     // D6       : 1 -        (  ,   - )
            DWORD       BitorderCD  :1;     // D7       : 1 -         (  ,   - )    "-"
            DWORD       Reset       :1;     // D8       : 1 -  
            DWORD       Reserved2   :3;     // D9..D11  : 
            DWORD       FIFOBlock   :3;     // D12..D14 :    
            DWORD       Reserved3   :1;     // D15      : 
            DWORD       Delimiter   :5;     // D16..D20 :   
            DWORD       Reserved4   :10;    // D21..D30 : 
            DWORD       Slave       :1;     // D31      : 1 -     Slave
        } bits;

    DWORD   AsULONG;

    };

    _DMDCH_CONTROL() {AsULONG = 0;};

} DMDCH_CTRL, *PDMDCH_CTRL;


/*++
      
--*/
enum SIGNAL_TYPE {  //                        ID

    stBPSK,         // 2                   [00]
    stQPSK,         // 4                   [01]
    stOQPSK,        // 4                  [02]
    st8PSK,         // 8                   [03]
    stQAM8,         // 8                  [04]
    stQAM16,        // 16                 [05]
    stQAM32,        // 32                 [06]
    stQAM64,        // 64                 [07]
    stPI2BPSK,      // pi/2 - BPSK           [08]
    stPI4QPSK,      // pi/4 - QPSK           [09]
    stDEC,          //        [10]
    stPRS,          // -2047              [11]
    stIQ,           //  I,Q            [12]
    stBPSK135,      // 2-135               [13]
    stAPSK16,       // 16                 [14]
    stAPSK32,       // 32                 [15]
    stQAM128,       // 128                [16]
    stQAM256,       // 256                [17]
    st8QAM_DS,      // 8QAM  PSM-500L  [18]
    st8QAM_PD,      // 8QAM  PD-60     [19]
    stDVBS2,        // DVB-S2                [20]
    stDVBS2X,       // DVB-S2X               [21]
    stCount         //
};

/*++
          8PSK  16APSK/32APSK
     . g -       16APSK/32APSK
--*/
enum SC_TYPE {

    SC_UNDEF=0,
    SC_8PSK_Intelsat,
    SC_8PSK_Gray_1,
    SC_8PSK_Gray_2,
    SC_8PSK_Gray_3,
    SC_8PSK_Natural,
    SC_16APSK_G3_15,    // g = 3.15
    SC_16APSK_G2_85,    // g = 2.85
    SC_16APSK_G2_75,    // g = 2.75
    SC_16APSK_G2_70,    // g = 2.70
    SC_16APSK_G2_60,    // g = 2.60
    SC_16APSK_G2_57,    // g = 2.57
    SC_32APSK_G2_84,    // g = 2.84
    SC_32APSK_G2_72,    // g = 2.72
    SC_32APSK_G2_64,    // g = 2.64
    SC_32APSK_G2_54,    // g = 2.54
    SC_32APSK_G2_53,    // g = 2.53
    SC_TOTAL
};

#define NUM_CHARS   (32)

//       
typedef struct _MOD_PARAMS {

    UCHAR   SignalID;                       //   
    UCHAR   SignalSR;                       //    
    UCHAR   SignalCT;                       //      8PSK, 16APSK/32APSK (SC_TYPE)

    CHAR    RAM1Filename[NUM_CHARS];        //     
    CHAR    RAM2Filename[NUM_CHARS];        //     
    CHAR    EQERRFilename[NUM_CHARS];       //    . 
    CHAR    RAMPackFilename[NUM_CHARS];     //    

    struct {
        LONG    AGC2;                       //   2- 
        LONG    Carrier;                    //   
        LONG    Timing;                     //   
    } Threshold;

    UCHAR   Reserved0;                      //  (   GetBitsPerChar)
    UCHAR   Reserved1;                      //  (        .)

} MOD_PARAMS, *PMOD_PARAMS;

//    
enum SYMBOL_RATE {

    SR0_0,      //

    SR1_2,      // 1/2
    SR2_3,      // 2/3
    SR3_4,      // 3/4
    SR4_5,      // 4/5
    SR5_6,      // 5/6
    SR7_8,      // 7/8
    SR8_9,      // 8/9
    SR9_10,     // 9/10

    srCount     //

};


/*++
          [DEM - 0x1C]
--*/
typedef struct _TIMING_MODE {
    union {
        struct {
            DWORD   Mode        :1;     // D0
            DWORD   Inverse     :1;     // D1
            DWORD   Reserved0   :6;     // D2...D7
            DWORD   DECMode     :4;     // D8...D11
            DWORD   Reserved1   :20;    // D12..D31
        } bits;
    DWORD   AsULONG;
    };

    _TIMING_MODE() {AsULONG = 0;};

} TIMING_MODE, *PTIMING_MODE;



/*++
    - 
--*/
typedef struct _BIT_STATUS {
    union {
        struct {
            DWORD   Carrier         :1;     //    
            DWORD   Timing          :1;     //    
            DWORD   SynchroRDY      :1;     //      /
            DWORD   IQDataRDY       :1;     //     IQ-
            DWORD   IQOverflow      :1;     //   FIFO IQ-
            DWORD   DMDDataRDY      :1;     //     FIFO DMD-
            DWORD   DMDOverflow     :1;     //   FIFO DMD-
            DWORD   SimulatorFIFO   :13;    //   FIFO      
            DWORD   Reserved0       :12;    // 
        } bits;
    DWORD   AsULONG;
    };

    _BIT_STATUS() {AsULONG = 0;};

} BIT_STATUS, *PBIT_STATUS;


/*/
 *   (ye/dB)      
/*/
typedef struct _GAIN_CONTROL_VALUES {

    // y.e.
    UINT    yeFirstGCHard;
    UINT    yeFirstGCSoft;
    UINT    Reserved0;
    UINT    yeSecondGC;

    // dB
    double  dBFirstGCHard;
    double  dBFirstGCSoft;
    double  Reserved1;
    double  dBSecondGC;

} GC_VALUES, *PGC_VALUES;



/*/
 *    
/*/
typedef struct _COUNTERS {

    DWORD   cntIQ;   //   FIFO IQ-
    DWORD   cntDMD;  //   FIFO DMD-
    DWORD   cntADC;  // -   (   )
    DWORD   cntMST;  // - 32-   ()    Master      
                     //(    )
    DWORD   Reserved1;
    
} COUNTERS, *PCOUNTERS;



/*++
      
--*/
typedef struct _DMPX_CONTROL {

    struct  {   //     

        DWORD   SynchroDetect;
        DWORD   SynchroLoss;
        
    } thresh;

    union {     //      [RS - 0x19]

        struct {

            DWORD   Skip            :4; // D0...D3  : - 
            DWORD   Reserved0       :2;
            DWORD   Descrambler     :1; // D6       : .(1)/.(0) 
            DWORD   Enabled         :1; // D7       : .(1)/.(0) 
            DWORD   Reserved1       :24;

        } bits;

    DWORD   AsULONG;

    };

    _DMPX_CONTROL() {AsULONG = 0;};

} DMPX_CTRL, *PDMPX_CTRL;


/*++
           [RS - 0x00]
--*/
typedef struct _DMPX_STATUS {

    union {
        struct {

            DWORD   Deinterleaver   :1; // D0   :  
            DWORD   RSDecoder       :1; // D1   :   -
            DWORD   Frame           :1; // D2   :   
            DWORD   SuperFrame      :1; // D3   :   
            DWORD   Reserved0       :28;

        } bitsSyncrho;

    DWORD   AsULONG;

    };

    _DMPX_STATUS() {AsULONG = 0;};

} DMPX_STATUS, *PDMPX_STATUS;


/*++
           [DEM - 0x24; DEM - 0x07FD]
--*/
typedef struct  _RESET_CTRL {
    union {
        struct {

            DWORD   PLL             :1; // D0       :  PLL    
            DWORD   FIFO            :1; // D1       :  FIFO     DVB-S2
            DWORD   Reserved        :30;// D2..D31  : 

        } bits;

    DWORD   AsULONG;

    };

    _RESET_CTRL() {AsULONG = 0;};

} RESET_CTRL, *PRESET_CTRL;


/*++
       
                                  [DEM - 0x19]
--*/
typedef struct _SIMULATOR_CTRL {
    union {
        struct {

            DWORD   BitOrder            :1;     // D0       :      (0) -     (1) - 
            DWORD   ByteOrder           :1;     // D1       :      (0) -     (1) - 
            DWORD   WordOrder           :1;     // D2       :   16-   32-  (0) -     (1) - 
            DWORD   SampleMode          :1;     // D3       :   (0) 8-  (1) - 16-
            DWORD   SampleInsert        :1;     // D4       : (1)         
            DWORD   RealOrCmplx         :1;     // D5       : (0)   (8-  16-)  (1) -  (16-)  
            DWORD   Reserved0           :1;     // D6       : 
            DWORD   Enable              :1;     // D7       : (1) .      (0)    
            DWORD   Reserved1           :24;    // D8..D31  : 
        } bits;

    DWORD AsULONG;

    };

    _SIMULATOR_CTRL() {AsULONG = 0;};

} SIMULATOR_CTRL, *PSIMULATOR_CTRL;


/*++
         .
--*/
typedef struct _FPGA_BAR {

    DWORD   INT;
    DWORD   DEM;
    DWORD   SYNTH;
    DWORD   DEC;
    DWORD   RS;

    UCHAR   Initialized;    //      : 
                            // 1 -  ; 0 - 
    UCHAR   Reserved0;
    UCHAR   Reserved1;
    UCHAR   Reserved2;

    _FPGA_BAR() : Initialized(0) {};

} FPGA_BAR, *PFPGA_BAR;

//
// Set the data alignment to default 
#pragma pack()


#endif

