/*++
    Copyright (c) 1999-2015  n-Joy

    THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
    KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
    IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
    PURPOSE.

Module Name:

    public.h

Abstract:

    This module contains the common declarations shared by driver
    and user applications.

Environment:

    User and Kernel

--*/

#ifndef _PUBLIC_H
#define _PUBLIC_H

#include <initguid.h>

//
// Define an Interface Guid for our device class.
// This GUID is used to register (WdfDeviceCreateDeviceInterface)
// an instance of an interface so that user application
// can control the device.
//

// {FEACD89E-A40A-4E39-8AAC-DE6B07C114D2}
DEFINE_GUID(GUID_DEVINTERFACE_DGSPM, 
0xfeacd89e, 0xa40a, 0x4e39, 0x8a, 0xac, 0xde, 0x6b, 0x7, 0xc1, 0x14, 0xd2);


//
// Define a WMI GUID to get DGSPM device info.
//
/*
// {BD37745F-4788-4562-889A-2C91FF0967B9}
DEFINE_GUID (DGSPM_WMI_STD_DATA_GUID,
0xbd37745f, 0x4788, 0x4562, 0x88, 0x9a, 0x2c, 0x91, 0xff, 0x9, 0x67, 0xb9);

//
// GUID definition are required to be outside of header inclusion pragma to avoid
// error during precompiled headers.
//
*/


//
// Structures are not packed
#pragma pack(1)

//
// Structure for Port read/write
//
typedef struct _PORT_DATA {

    ULONG       Port;
    ULONG       Data;
    ULONG       Reserved0;
    ULONG       Reserved1;

} PORT_DATA, * PPORT_DATA;

//
// Memory buffer structure
//
// 52-bytes in size at x64  model
// 32-bytes in size at i386 model
typedef struct _MEMORY_BUFFER_UM {  // for user-mode

    ULONG               Size;
 
    PULONG              UserVA;
    PVOID               Reserved;
    LARGE_INTEGER       MemoryPA;   // .LowPart should be used

    PVOID               Reserved0;
    PVOID               Reserved1;
    PVOID               Reserved2;
    
} UNALIGNED MEMORY_BUFFER_UM, *PMEMORY_BUFFER_UM;


//
// Memory data structure
// 
// 20-bytes in size at x64  model
// 16-bytes in size at i386 model
typedef struct _MEMORY_DATA {

    ULONG               Count;      // number of memory buffers
    PMEMORY_BUFFER_UM   Buffers;    // memory buffers array

    ULONG               Reserved0;
    ULONG               Reserved1;

} UNALIGNED MEMORY_DATA, *PMEMORY_DATA;


//
// Structure for getting interrupt information per CH
// 
typedef struct _CHIRQ_BUFFER {

    ULONG       CH;                 // Channel number
    ULONG       cntIRQ;             // Number of IRQs
    ULONG       cntDPCFail;         // Number of IRQs failed to queue for DPC
    ULONG       TotalIRQ;           // Total number of the device IRQs

    ULONG       Reserved0;          // Reserved
    ULONG       Reserved1;          // Reserved

} CHIRQ_BUFFER, *PCHIRQ_BUFFER;

//
// IRQ data structure
// 
// 20-bytes in size at x64  model
// 16-bytes in size at i386 model
typedef struct _INTERRUPT_INFO {

    ULONG           Count;              // Number of IRQ information structures (CHs)
    PCHIRQ_BUFFER   Buffers;            // Array of IRQ information for each CH

    ULONG           Reserved0;          // Reserved
    ULONG           Reserved1;          // Reserved

} INTERRUPT_INFO, *PINTERRUPT_INFO;


//
// Structure for mapping BAR
// 
// 20-bytes in size at x64  model
// 16-bytes in size at i386 model
typedef struct _BAR_BUFFER {

    PULONG      UserVA;
    ULONG       Length;

    ULONG       Reserved0;
    ULONG       Reserved1;

} BAR_BUFFER, *PBAR_BUFFER;


//
// Set the data alignment to default 
#pragma pack()


#endif
